#pragma once
#include "PMC_Acontis_Cpp_API.h"
#include <chrono>
#include <ctime>
#include <string>
#include <fstream>
#include <iostream>
#include <thread>

using namespace PMC;
using namespace std;
using namespace std::chrono;
#define PI 3.141592654

void PollForXbotState(PMC_Acontis_API* PMC,int XbotID, XBOTSTATE state = XBOTSTATE::XBOT_IDLE);

void PollForAllXbotsState(PMC_Acontis_API* PMC,XBOTSTATE state = XBOTSTATE::XBOT_IDLE);

void PollForPMCState(PMC_Acontis_API* PMC,PMCSTATUS state = PMCSTATUS::PMC_FULLCTRL);

//2x1 flyways w/ 1 xbots - linear, arc target, block buffer, release buffer, clear macro, save macro, run macro
void Example01_longaxismotion(PMC_Acontis_API* PMC);

//2x1 flyways w/ 1 xbots - short axis, 6 dof, 6 dof w speed
void Example02_shortaxismotion(PMC_Acontis_API* PMC);

//2x1 flyways w/ 2 xbots - async,async velocity, create group,block&release group buffer, bond&unbond group
void Example03_groups(PMC_Acontis_API* PMC);

//2x1 flyways w/ 2 xbots - waituntil cmdlb,waituntil displacement
void Example04_waituntil(PMC_Acontis_API* PMC);

//2x2 flyways w/ 1 xbots sample trajectory set as trajectory 1 (time interval = 10 ms) - trajectory, pause, resume, stop, deactivate, reboot, activate, levitate, arc center
void Example05_pmccontrol(PMC_Acontis_API* PMC);

//4x3 flyways, 4 xbots - get xbot prop, set xbot prop, sync move
void Example06_sync(PMC_Acontis_API* PMC);

//4x3 flyways 2 xbots - sun planet
void Example07_sun(PMC_Acontis_API* PMC);

//4x3 flyways 2 xbots - get pmc state, get buffer status
void Example08_bufferstatus(PMC_Acontis_API* PMC);

//2x1 flyways 2 xbots - delete group, get group status, get macro status
void Example09_groupstatus(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbots - get xbot status, wait until delay
void Example10_waituntiltime(PMC_Acontis_API* PMC);

//>= 1 xbot
void Example11_readxbotposition(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - send digital signal to PMC, macro trigger from DI
void Example12_DImacro(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - waituntil DI, config DI as trigger
void Example13_waituntilDI(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - DO set on cmdlb, DI as reset, read DO from PMC
void Example14_DOcmdlb(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - DO set on displacement
void Example15_DOdisplacement(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - DO set on motion
void Example16_DOmotion(PMC_Acontis_API* PMC);

//4x3 flyways 2 xbot sample cam set as cam 128 (position interval = 1 mm) - cam mode, cam mode advanced
void Example17_cam(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - jogging, jogging short axis
void Example18_jogging(PMC_Acontis_API* PMC);

// 1 flyway (actual physical) w/ 1 xbots - force mode ctrl,read payload,read flyway temps
void Example19_force(PMC_Acontis_API* PMC);

// 1 flyway (actual physical) w/ 1 xbots - DO set on force
void Example20_DOforce(PMC_Acontis_API* PMC);

//any amount of xbots 
void Example21_startupPMS(PMC_Acontis_API* PMC);

//5x2 flyways 9 xbots (y axis feedback must be enabled) - StreamModeCtrl,WriteStream,ConfigFBStream,read feedback
void Example22_streaming(PMC_Acontis_API* PMC,void* EcEventPointer);

//streaming timer task
void Example22_streamingtimerhandler(void* context);

//4x3 flyways 4 xbots - HoldForPMCState, HoldForXbot(s)Idle, HoldForXbot(s)State
void Example23_autodrivingvelocity(PMC_Acontis_API* PMC);

//1 flyway 1 xbot (actual physical) - autoloading delete,create,activate,holdforzoneready,unload
void Example24a_autoloading_sending(PMC_Acontis_API* PMC);

//1 flyway 1 xbot (actual physical, xbot not on flyway at beginning of example) - autoloading delete,create,activate,holdforzoneready,loadingzoneclear 
void Example24b_autoloading_receiving(PMC_Acontis_API* PMC);

//4x3 flyways 1 xbot - MoverStereotype Define, Assign, ReadDef
void Example25_stereotypes(PMC_Acontis_API* PMC);

//at least 2 flyways (physical) - GetFlywaySerialNum, PMC_GetPMCSerialNum, PMC_GetPMCVersion
void Example26_serialnumbers(PMC_Acontis_API* PMC);

//2x1 flyways 1 xbot - LevitationLandw/Speed
void Example27_levitatelandspeed(PMC_Acontis_API* PMC);

//2x1 flyways 2 xbots (actual physical) - ZoneCtrl, GetStatus
void Example28a_zoneunloading(PMC_Acontis_API* PMC);

//2x1 flyways 2 xbots (actual physical, shoud be run after 27a) - ZoneCtrl, FenceCtrl, GetStatus 
void Example28b_zoneloading(PMC_Acontis_API* PMC);

//any number of flyways and xbots (real physical, with at least 1 xbot having suffered a tracking error) - GetAllAccidentXbots, RecoverAccidentXbot
//a tracking error can be triggered by holding a xbot down for about 3 seconds
void Example29_recoveryaccident(PMC_Acontis_API* PMC);

//2x1 flyways 1 xbot (actual physical) with border 1 on the bottom edge of the 2 flyways - GetBorderStatus, ReadNumIncomingXbots, GetIncomingXbots
//additional user controlled PMC with 2x1 flyways with border 1 on the top edge, xbot starts on the user controlled PMC
void Example30_incoming(PMC_Acontis_API* PMC);

//any flyway configuration 50 xbots - PMC_ConfigFBStreamExtended, PMC_ReadStreamFeedbackExtended, PMC_ReadXbotSpeed
void Example31_extendedfeedback(PMC_Acontis_API* PMC);

//2x1 flyways 1 xbots - ZoneFencing,DefineZone,ZoneGetStatus
void Example32_zonefencing(PMC_Acontis_API* PMC);

//Initial setup for Example33_StarWheel
void Example33_StarWheelSetup(PMC_Acontis_API* PMC);

//streaming timer task
void Example33_streamingtimerhandler(void* context);

//3x3 flyways 6 xbots - star wheel module demo CreateStar, DeleteStar, GetStarStatus, SendXbotToStar, StarExitClear
void Example33_StarWheel(PMC_Acontis_API* PMC,void* EcEventPointer);

//1x1 flyways 1 xbots - SingleAxisMotion,RotaryMotion,RotaryMotionSpin
void Example34_RotaryMotion(PMC_Acontis_API* PMC);

//2x1 flyways 1 xbot (actual physical, left flyway set as master, right flyway set as sector 1) - PMC_Sector_Activate, PMC_Sector_Deactivate, PMC_Sector_Recover, PMC_Sector_GetStatus
void Example35_Sectors(PMC_Acontis_API* PMC);

//any combination of xbots and flyways - SetDateAndTime
void Example36_SetDateAndTime(PMC_Acontis_API* PMC);

//5x5 flyways - up to 10 xbots with the example application design loaded on the PMC as design 1
void Example37_ApplicationDesigner(PMC_Acontis_API* PMC);

//3x3 flyways 1 xbot - DeleteGCode,SaveGCode,ReadGCode,GetGCodeIDs,RunGCode. G-code file 'GCodeDemo.txt' must be on disc in the DemoFilesFolder.  
void FileExample01_Gcode(PMC_Acontis_API* PMC, std::string DemoFilesFolder);

//any combination of flyways and xbots - GetErrorLog, GetWarningLog. Any existing 'warning_log.txt' or 'error_log.txt' file in DemoFilesFolder will be overwritten
void FileExample02_ReadLogs(PMC_Acontis_API* PMC, string DemoFilesFolder);

//1x1 1 xbot - DeleteTrajectory, SaveTrajectory, ReadTrajectoryHash. Trajectory file 'TrajectoryDemo.txt' must be on disc in the DemoFilesFolder.
void FileExample03_Trajectory(PMC_Acontis_API* PMC, string DemoFilesFolder);

//any configuration of xbots and flyways - SetConfiguration, GetConfiguration. Configuration XML file 'PMCConfig.xml' must be on disc in the DemoFilesFolder
void FileExample04_Configuration(PMC_Acontis_API* PMC, string DemoFilesFolder);